/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgPathException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchOracleHomes;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OracleHomeChecks {
    private OracleHomeChecks() {
    }

    public static OipcrIResult checkHomeWritability(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block11: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    List oHomesList = OracleHomeChecks.getHomeInfo(oRulesEngine, sRefFile, "HOME_LOC");
                    String[] asHomeLocs = OiixVectorOps.list2StrArr((List)oHomesList);
                    if (asHomeLocs == null || asHomeLocs.length == 0) break block11;
                    ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                    for (int i = 0; i < asHomeLocs.length; ++i) {
                        OipcrIResult oRes = null;
                        try {
                            String sWritableLoc = OiipgFileSystem.checkWritablePath((String)asHomeLocs[i]);
                            oRes = OipcrResult.PASSED_RESULT;
                        }
                        catch (OiipgPathException ope) {
                            oRes = OipcrResult.FAILED_RESULT;
                        }
                        oResDetails.add(new OipcrResultDetails(null, (Object)asHomeLocs[i], oRes));
                    }
                    oResult = new OipcrResult(oResDetails);
                }
                catch (OipcrExecuteRuleException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    public static OipcrIResult checkIfHomeLocEmpty(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine != null) {
            try {
                List oHomesList = OracleHomeChecks.getHomeInfo(oRulesEngine, sRefFile, "HOME_LOC");
                String[] asHomeLocs = OiixVectorOps.list2StrArr((List)oHomesList);
                if (asHomeLocs != null && asHomeLocs.length != 0) {
                    ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                    for (int i = 0; i < asHomeLocs.length; ++i) {
                        OipcrIResult oRes = null;
                        oRes = OracleHomeChecks.isEmptyDir(asHomeLocs[i]) ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                        oResDetails.add(new OipcrResultDetails(null, (Object)asHomeLocs[i], oRes));
                    }
                    oResult = new OipcrResult(oResDetails);
                }
            }
            catch (OipcrExecuteRuleException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkIfSpaceInOH(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine != null) {
            try {
                List oHomesList = OracleHomeChecks.getHomeInfo(oRulesEngine, sRefFile, "HOME_LOC");
                String[] asHomeLocs = OiixVectorOps.list2StrArr((List)oHomesList);
                if (asHomeLocs != null && asHomeLocs.length != 0) {
                    ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                    for (int i = 0; i < asHomeLocs.length; ++i) {
                        OipcrIResult oRes = null;
                        oRes = asHomeLocs[i].indexOf(32) == -1 ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                        oResDetails.add(new OipcrResultDetails(null, (Object)asHomeLocs[i], oRes));
                    }
                    oResult = new OipcrResult(oResDetails);
                }
            }
            catch (OipcrExecuteRuleException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    private static boolean isEmptyDir(String sDir) {
        boolean bIsEmptyDir = true;
        File fLoc = new File(sDir);
        if (fLoc.exists()) {
            if (fLoc.isFile()) {
                bIsEmptyDir = false;
            } else if (fLoc.isDirectory()) {
                String[] dirList = fLoc.list();
                if (null != dirList && 0 < dirList.length) {
                    bIsEmptyDir = false;
                }
            } else {
                bIsEmptyDir = false;
            }
        }
        return bIsEmptyDir;
    }

    public static OipcrIResult checkIfHomeNameUnique(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine != null) {
            try {
                List oHomesList;
                String[] asHomeNames;
                OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                OipchOracleHomes oOracleHomes = oHost.getOracleHomes();
                OiiiInstallInventory oInv = null;
                if (oOracleHomes != null) {
                    oInv = oOracleHomes.getInstallInventory();
                }
                if ((asHomeNames = OiixVectorOps.list2StrArr((List)(oHomesList = OracleHomeChecks.getHomeInfo(oRulesEngine, sRefFile, "HOMENAME")))) != null && asHomeNames.length != 0) {
                    ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                    for (int i = 0; i < asHomeNames.length; ++i) {
                        OipcrIResult oRes = null;
                        if (OracleHomeChecks.isHomeNameUnique(asHomeNames[i], oInv)) {
                            oRes = OipcrResult.PASSED_RESULT;
                            for (int j = 0; j < asHomeNames.length; ++j) {
                                if (i == j || !asHomeNames[i].equals(asHomeNames[j])) continue;
                                oRes = OipcrResult.FAILED_RESULT;
                            }
                        } else {
                            oRes = OipcrResult.FAILED_RESULT;
                        }
                        oResDetails.add(new OipcrResultDetails(null, (Object)asHomeNames[i], oRes));
                    }
                    oResult = new OipcrResult(oResDetails);
                }
            }
            catch (OipcrExecuteRuleException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkExistingHome(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block28: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                    OipchOracleHomes oOracleHomes = oHost.getOracleHomes();
                    boolean bCleanMachine = false;
                    if (oOracleHomes != null) {
                        Node oExistenceMatNode;
                        OiiiInstallInventory oInstallInventory = oOracleHomes.getInstallInventory();
                        if (oInstallInventory == null) {
                            bCleanMachine = true;
                        }
                        if ((oExistenceMatNode = oGenRefHost.getNode("ORACLE_HOME/EXISTENCE_MATRIX")) != null) {
                            NodeList oCompNodes = oExistenceMatNode.getChildNodes();
                            if (oCompNodes != null) {
                                int iCompNodes = oCompNodes.getLength();
                                Node oCompNode = null;
                                NamedNodeMap oCompNodeAttribs = null;
                                Node oAttrib = null;
                                ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                                OipcrIResult oRes = null;
                                for (int i = 0; i < iCompNodes; ++i) {
                                    String sExpectedValue = null;
                                    String sActualValue = null;
                                    oCompNode = oCompNodes.item(i);
                                    if (oCompNode.getNodeType() != 1 || !oCompNode.getNodeName().equalsIgnoreCase("COMP")) continue;
                                    oCompNodeAttribs = oCompNode.getAttributes();
                                    if (oCompNodeAttribs != null) {
                                        String sOHLocVar;
                                        OiisVariable oVar;
                                        oAttrib = oCompNodeAttribs.getNamedItem("NAME");
                                        String sCompName = null;
                                        if (oAttrib == null) {
                                            Object[] args = new String[]{sRefFile};
                                            throw new OipcrExecuteRuleException("S_NO_NAME_FOR_COMP_UNDER_EXIST_MAT", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_NAME_FOR_COMP_UNDER_EXIST_MAT", (Object[])args));
                                        }
                                        sCompName = oAttrib.getNodeValue();
                                        oAttrib = oCompNodeAttribs.getNamedItem("ATLEAST");
                                        String sMinVer = "0.0.0.0";
                                        if (oAttrib != null) {
                                            sMinVer = oAttrib.getNodeValue();
                                        }
                                        oAttrib = oCompNodeAttribs.getNamedItem("ATMOST");
                                        String sMaxVer = "99.99.99.99";
                                        if (oAttrib != null) {
                                            sMaxVer = oAttrib.getNodeValue();
                                        }
                                        oAttrib = oCompNodeAttribs.getNamedItem("DESC");
                                        String sDesc = null;
                                        if (oAttrib != null) {
                                            sDesc = oAttrib.getNodeValue();
                                        }
                                        boolean bExists = false;
                                        oAttrib = oCompNodeAttribs.getNamedItem("EXISTS");
                                        if (oAttrib != null && oAttrib.getNodeValue().equalsIgnoreCase("TRUE")) {
                                            bExists = true;
                                        }
                                        String sOHLoc = null;
                                        oAttrib = oCompNodeAttribs.getNamedItem("VAR");
                                        if (oAttrib != null && (oVar = oContext.getVariable(sOHLocVar = oAttrib.getNodeValue())) != null) {
                                            sOHLoc = (String)oVar.getValue();
                                        }
                                        boolean bPresent = false;
                                        if (sDesc != null) {
                                            sExpectedValue = sDesc;
                                        }
                                        if (!bCleanMachine) {
                                            AbstractList oHomes = null;
                                            if (sOHLoc != null) {
                                                OiiiOracleHomeInfo oOraHomeInfo = oInstallInventory.getHomeWithLocation(sOHLoc);
                                                if (oOraHomeInfo != null) {
                                                    oHomes = new ArrayList();
                                                    oHomes.add(oOraHomeInfo);
                                                }
                                            } else {
                                                oHomes = oInstallInventory.getHomes();
                                            }
                                            if (oHomes != null) {
                                                int iSize = oHomes.size();
                                                for (int j = 0; j < iSize; ++j) {
                                                    OiiiOracleHomeInfo oOhi = (OiiiOracleHomeInfo)oHomes.get(j);
                                                    OiiiInstallCompInvEntry oEntry = OracleHomeChecks.doesHomeExist(oInstallInventory, oOhi, sCompName, sMinVer, sMaxVer);
                                                    if (oEntry == null) continue;
                                                    bPresent = true;
                                                    sActualValue = oOhi.getLocation();
                                                    sExpectedValue = oEntry.getFullDisplayName();
                                                }
                                            }
                                        }
                                        oRes = bPresent == bExists ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                                    } else {
                                        Object[] args = new String[]{sRefFile};
                                        throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_COMP_UNDER_EXIST_MAT", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_COMP_UNDER_EXIST_MAT", (Object[])args));
                                    }
                                    oResDetails.add(new OipcrResultDetails(sActualValue, (Object)sExpectedValue, oRes));
                                }
                                oResult = new OipcrResult(oResDetails);
                            }
                            break block28;
                        }
                        Object[] args = new String[]{sRefFile};
                        throw new OipcrExecuteRuleException("S_NO_EXISTENCE_MAT_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_EXISTENCE_MAT_INFO", (Object[])args));
                    }
                    throw new OipcrExecuteRuleException("S_NO_ORACLE_HOME_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ORACLE_HOME_INFO"));
                }
                catch (OipcrExecuteRuleException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    private static OiiiInstallCompInvEntry doesHomeExist(OiiiInstallInventory oInv, OiiiOracleHomeInfo oOhi, String sCompName, String sMinVer, String sMaxVer) {
        OiiiInstallCompInvEntry oEntry = null;
        if (oOhi != null && (oEntry = oInv.findCompInRange(oOhi.getIndex(), sCompName, sMinVer, sMaxVer)) != null && oEntry.getCompInstallID().getVersion().laterThan(new OiiiVersion(sMaxVer))) {
            oEntry = null;
        }
        return oEntry;
    }

    private static List getHomeInfo(OipcrIRulesEngine oRulesEngine, String sRefFile, String sTag) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        ArrayList<String> oHomesList = new ArrayList<String>();
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oHomesNode = oGenRefHost.getNode("ORACLE_HOME/HOMES");
        String sHomeLocVar = null;
        OiisVariable oVar = null;
        String sHomeLoc = null;
        if (oHomesNode != null) {
            NodeList oHomeNodes = oHomesNode.getChildNodes();
            if (oHomeNodes != null) {
                int iNodes = oHomeNodes.getLength();
                Node oHomeNode = null;
                NamedNodeMap oNodeAttribs = null;
                Node oAttrib = null;
                for (int i = 0; i < iNodes; ++i) {
                    oHomeNode = oHomeNodes.item(i);
                    if (oHomeNode.hasChildNodes() && oHomeNode.getChildNodes().getLength() != 0) {
                        NodeList oHomeChildren = oHomeNode.getChildNodes();
                        int nHomeChildren = oHomeChildren.getLength();
                        for (int i1 = 0; i1 < nHomeChildren; ++i1) {
                            Node childofHome = oHomeChildren.item(i1);
                            if (childofHome.getNodeType() != 1 || !childofHome.getNodeName().equalsIgnoreCase(sTag)) continue;
                            oNodeAttribs = childofHome.getAttributes();
                            if (oNodeAttribs != null) {
                                oAttrib = oNodeAttribs.getNamedItem("VAR");
                                sHomeLocVar = null;
                                if (oAttrib == null) {
                                    Object[] args1 = new String[]{sRefFile};
                                    throw new OipcrExecuteRuleException("S_NO_VAR_FOR_HOME_UNDER_HOMES", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_HOME_UNDER_HOMES", (Object[])args1));
                                }
                                sHomeLocVar = oAttrib.getNodeValue();
                                oVar = oContext.getVariable(sHomeLocVar);
                                if (oVar == null || (sHomeLoc = (String)oVar.getValue()) == null) continue;
                                oHomesList.add(sHomeLoc);
                                continue;
                            }
                            Object[] args1 = new String[]{sRefFile};
                            throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_HOME_UNDER_HOMES", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_HOME_UNDER_HOMES", (Object[])args1));
                        }
                        continue;
                    }
                    String sTag1 = null;
                    sTag1 = sTag.equalsIgnoreCase("HOME_LOC") ? "HOME" : sTag;
                    if (oHomeNode.getNodeType() != 1 || !oHomeNode.getNodeName().equalsIgnoreCase(sTag1)) continue;
                    oNodeAttribs = oHomeNode.getAttributes();
                    if (oNodeAttribs != null) {
                        oAttrib = oNodeAttribs.getNamedItem("VAR");
                        sHomeLocVar = null;
                        if (oAttrib == null) {
                            Object[] args = new String[]{sRefFile};
                            throw new OipcrExecuteRuleException("S_NO_VAR_FOR_HOME_UNDER_HOMES", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_HOME_UNDER_HOMES", (Object[])args));
                        }
                        sHomeLocVar = oAttrib.getNodeValue();
                        oVar = oContext.getVariable(sHomeLocVar);
                        if (oVar == null || (sHomeLoc = (String)oVar.getValue()) == null) continue;
                        oHomesList.add(sHomeLoc);
                        continue;
                    }
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_HOME_UNDER_HOMES", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_HOME_UNDER_HOMES", (Object[])args));
                }
            }
        } else {
            Object[] args = new String[]{sRefFile};
            throw new OipcrExecuteRuleException("S_NO_HOMES_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_HOMES_INFO", (Object[])args));
        }
        return oHomesList;
    }

    private static boolean isHomeNameUnique(String sHomeName, OiiiInstallInventory oInv) {
        OiiiOracleHomeInfo oOhi;
        boolean bUnique = true;
        if (oInv != null && (oOhi = oInv.getHomeWithName(sHomeName)) != null) {
            bUnique = false;
        }
        return bUnique;
    }
}

